/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.general.decomposition.Inv;
import org.ujmp.core.doublematrix.calculation.general.decomposition.LU;
import org.ujmp.core.util.DecompositionOps;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface InvSymm<T>
extends Inv<T> {
    public static final int THRESHOLD = 100;
    public static final InvSymm<Matrix> MATRIX = new InvSymm<Matrix>(){

        @Override
        public final Matrix calc(Matrix source) {
            if (source.getDimensionCount() != 2 || source.getRowCount() != source.getColumnCount()) {
                throw new RuntimeException("inverse only possible for square matrices. use pinv or ginv instead");
            }
            if (UJMPSettings.getInstance().getNumberOfThreads() == 1) {
                if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                    return MATRIXLARGESINGLETHREADED.calc(source);
                }
                return MATRIXSMALLSINGLETHREADED.calc(source);
            }
            if (source.getRowCount() >= 100L && source.getColumnCount() >= 100L) {
                return MATRIXLARGEMULTITHREADED.calc(source);
            }
            return MATRIXSMALLMULTITHREADED.calc(source);
        }
    };
    public static final InvSymm<Matrix> UJMP = new InvSymm<Matrix>(){

        @Override
        public final Matrix calc(Matrix source) {
            DenseDoubleMatrix2D b = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(source.getRowCount(), source.getRowCount());
            int i = (int)source.getRowCount();
            while (--i >= 0) {
                b.setDouble(1.0, i, i);
            }
            return LU.INSTANCE.solve(source, b);
        }
    };
    public static final InvSymm<Matrix> INSTANCE = MATRIX;
    public static final InvSymm<Matrix> MATRIXSMALLSINGLETHREADED = UJMP;
    public static final InvSymm<Matrix> MATRIXLARGESINGLETHREADED = new InvSymm<Matrix>(){

        @Override
        public final Matrix calc(Matrix source) {
            Inv<Object> inv = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                inv = DecompositionOps.INV_JBLAS;
            }
            if (inv == null && UJMPSettings.getInstance().isUseOjalgo()) {
                inv = DecompositionOps.INV_OJALGO;
            }
            if (inv == null && UJMPSettings.getInstance().isUseEJML()) {
                inv = DecompositionOps.INV_EJML;
            }
            if (inv == null && UJMPSettings.getInstance().isUseMTJ()) {
                inv = DecompositionOps.INV_MTJ;
            }
            if (inv == null) {
                inv = UJMP;
            }
            return inv.calc(source);
        }
    };
    public static final InvSymm<Matrix> MATRIXLARGEMULTITHREADED = new InvSymm<Matrix>(){

        @Override
        public Matrix calc(Matrix source) {
            Inv<Object> inv = null;
            if (UJMPSettings.getInstance().isUseJBlas()) {
                inv = DecompositionOps.INV_JBLAS;
            }
            if (inv == null && UJMPSettings.getInstance().isUseOjalgo()) {
                inv = DecompositionOps.INV_OJALGO;
            }
            if (inv == null && UJMPSettings.getInstance().isUseEJML()) {
                inv = DecompositionOps.INV_EJML;
            }
            if (inv == null && UJMPSettings.getInstance().isUseMTJ()) {
                inv = DecompositionOps.INV_MTJ;
            }
            if (inv == null) {
                inv = UJMP;
            }
            return inv.calc(source);
        }
    };
    public static final InvSymm<Matrix> MATRIXSMALLMULTITHREADED = UJMP;

    @Override
    public T calc(T var1);
}

