/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.ext;

import edu.mit.broad.xbench.actions.XAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.net.URI;
import javax.swing.Icon;

public class BrowserAction
extends XAction {
    private String urlString;

    public BrowserAction(String name, String desc, Icon icon, String urlString) {
        super("BrowserAction", name, desc, icon);
        this.setUrlString(urlString);
    }

    public String getUrlString() {
        return this.urlString;
    }

    public void setUrlString(String urlString) {
        this.urlString = urlString;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            String path = this.getUrlString();
            if (path == null) {
                throw new NullPointerException("null URL associated with BrowserAction");
            }
            URI uri = new URI(path);
            Desktop.getDesktop().browse(uri);
            Application.getFileManager().registerRecentlyOpenedURL(this.getUrlString());
        }
        catch (Exception e) {
            Application.getWindowManager().showError("Could not launch browser", e);
        }
    }
}

