/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.dialog.AbstractDialogPage;
import com.jidesoft.dialog.BannerPanel;
import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.MultiplePageDialog;
import com.jidesoft.dialog.PageList;
import com.jidesoft.swing.PartialLineBorder;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class GseaPreferencesDialog
extends MultiplePageDialog {
    public GseaPreferencesDialog(Frame owner, String title) throws HeadlessException {
        super(owner, title);
        super.setStyle(3);
        PageList model = new PageList();
        FirebirdOptionPage_general panel1 = new FirebirdOptionPage_general("General", JarResources.getImageIcon("prefs_general.png"));
        FirebirdOptionPage_alg panel2 = new FirebirdOptionPage_alg("Algorithms", JarResources.getImageIcon("PreferencesSystemBig.png"));
        model.append((AbstractDialogPage)panel1);
        model.append((AbstractDialogPage)panel2);
        super.setPageList(model);
    }

    protected void initComponents() {
        super.initComponents();
        this.getContentPanel().setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.getIndexPanel().setBackground(Color.white);
        this.getButtonPanel().setBorder(BorderFactory.createEmptyBorder(20, 10, 10, 10));
        this.getPagesPanel().setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = super.createButtonPanel();
        AbstractAction okAction = new AbstractAction(UIManager.getString("OptionPane.okButtonText")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GseaPreferencesDialog.this.setDialogResult(0);
                GseaPreferencesDialog.this.savePreferences();
                GseaPreferencesDialog.this.setVisible(false);
                Application.getWindowManager().showMessage("Saved preferences (many preferences need a restart of GSEA)");
                GseaPreferencesDialog.this.dispose();
            }
        };
        AbstractAction cancelAction = new AbstractAction(UIManager.getString("OptionPane.cancelButtonText")){

            @Override
            public void actionPerformed(ActionEvent e) {
                GseaPreferencesDialog.this.setDialogResult(-1);
                GseaPreferencesDialog.this.setVisible(false);
                GseaPreferencesDialog.this.dispose();
            }
        };
        buttonPanel.getButtonByName("APPLY").setVisible(false);
        ((JButton)buttonPanel.getButtonByName("OK")).setAction(okAction);
        ((JButton)buttonPanel.getButtonByName("CANCEL")).setAction(cancelAction);
        buttonPanel.addButton((AbstractButton)JarResources.createHelpButton("gsea_preferences_widget"), (Object)"HELP");
        this.setDefaultCancelAction(cancelAction);
        this.setDefaultAction(okAction);
        return buttonPanel;
    }

    private void savePreferences() {
        try {
            XPreferencesFactory.kAskBeforeAppShutdown.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kOnlineMode.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kCytoscapeRESTPort.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kDefaultReportsOutputDir.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kMakeGseaUpdateCheck.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kBiasedVar.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kMedian.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.kFixLowVar.setValueOfPref2SelectionComponentValue();
            XPreferencesFactory.save();
        }
        catch (Exception e) {
            Application.getWindowManager().showError("Trouble saving preferences", e);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(750, 540);
    }

    private static StringBuffer _createRowStr(int num) {
        StringBuffer rowStr = new StringBuffer();
        rowStr.append("pref, 5dlu,");
        for (int i = 0; i < num; ++i) {
            rowStr.append("pref, 3dlu");
            if (num == i - 1) continue;
            rowStr.append(",");
        }
        return rowStr;
    }

    private static CompoundBorder createRoundCornerBorder(String title) {
        return BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder((Border)new PartialLineBorder(Color.gray, 1, true), title), BorderFactory.createEmptyBorder(0, 6, 4, 6));
    }

    static class FirebirdOptionPage_alg
    extends FirebirdOptionPage {
        public FirebirdOptionPage_alg(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void initComponents() {
            super.initComponents();
            this.add(this.createPanel(this), "Center");
        }

        private JPanel createPanel(AbstractDialogPage page) {
            String str = "200dlu,      4dlu,        50dlu";
            int rowCnt = 3;
            StringBuffer rowStr = GseaPreferencesDialog._createRowStr(5);
            FormLayout layout = new FormLayout("200dlu,      4dlu,        50dlu", rowStr.toString());
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)new JLabel(XPreferencesFactory.kMedian.getName()), cc.xy(1, rowCnt));
            builder.add((Component)XPreferencesFactory.kMedian.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            builder.add((Component)new JLabel(XPreferencesFactory.kFixLowVar.getName()), cc.xy(1, rowCnt += 2));
            builder.add((Component)XPreferencesFactory.kFixLowVar.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            builder.add((Component)new JLabel(XPreferencesFactory.kBiasedVar.getName()), cc.xy(1, rowCnt += 2));
            builder.add((Component)XPreferencesFactory.kBiasedVar.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            JPanel bpanel = builder.getPanel();
            bpanel.setBorder(GseaPreferencesDialog.createRoundCornerBorder(" These are 'Defaults' "));
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            panel.add(Box.createVerticalStrut(6));
            panel.add(bpanel);
            panel.add(Box.createVerticalStrut(6));
            return panel;
        }
    }

    static class FirebirdOptionPage_general
    extends FirebirdOptionPage {
        public FirebirdOptionPage_general(String name, Icon icon) {
            super(name, icon);
        }

        @Override
        public void initComponents() {
            super.initComponents();
            this.add(this.createPanel(this), "Center");
        }

        private JPanel createPathsPanel() {
            String str = "275dlu";
            int rowCnt = 3;
            StringBuffer rowStr = GseaPreferencesDialog._createRowStr(5);
            FormLayout layout = new FormLayout("275dlu", rowStr.toString());
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)new JLabel("Cytoscape REST port (for Enrichment Map Visualization)"), cc.xy(1, rowCnt));
            builder.add((Component)XPreferencesFactory.kCytoscapeRESTPort.getSelectionComponent().getComponent(), cc.xy(1, rowCnt += 2));
            JPanel panel = builder.getPanel();
            panel.setBorder(GseaPreferencesDialog.createRoundCornerBorder(" Program settings "));
            return panel;
        }

        private JPanel createOutputPanel() {
            String str = "75dlu,      4dlu,        200dlu";
            int rowCnt = 3;
            StringBuffer rowStr = GseaPreferencesDialog._createRowStr(1);
            FormLayout layout = new FormLayout("75dlu,      4dlu,        200dlu", rowStr.toString());
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)new JLabel("Default output folder"), cc.xy(1, rowCnt));
            builder.add((Component)XPreferencesFactory.kDefaultReportsOutputDir.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            JPanel panel = builder.getPanel();
            panel.setBorder(GseaPreferencesDialog.createRoundCornerBorder(" Report settings "));
            return panel;
        }

        private JPanel createAppPreferencesPanel() {
            String str = "180dlu,      4dlu,        10dlu";
            int rowCnt = 5;
            StringBuffer rowStr = GseaPreferencesDialog._createRowStr(5);
            FormLayout layout = new FormLayout("180dlu,      4dlu,        10dlu", rowStr.toString());
            PanelBuilder builder = new PanelBuilder(layout);
            builder.setDefaultDialogBorder();
            CellConstraints cc = new CellConstraints();
            builder.add((Component)new JLabel("Prompt before closing application"), cc.xy(1, rowCnt));
            builder.add((Component)XPreferencesFactory.kAskBeforeAppShutdown.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            builder.add((Component)new JLabel("Connect over the Internet"), cc.xy(1, rowCnt += 2));
            builder.add((Component)XPreferencesFactory.kOnlineMode.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            builder.add((Component)new JLabel("Check for new GSEA version on startup"), cc.xy(1, rowCnt += 2));
            builder.add((Component)XPreferencesFactory.kMakeGseaUpdateCheck.getSelectionComponent().getComponent(), cc.xy(3, rowCnt));
            JPanel panel = builder.getPanel();
            panel.setBorder(GseaPreferencesDialog.createRoundCornerBorder(" Application preferences "));
            return panel;
        }

        private JPanel createPanel(AbstractDialogPage page) {
            JPanel outPanel = this.createOutputPanel();
            JPanel pathsPanel = this.createPathsPanel();
            JPanel windowsAndTabsPanel = this.createAppPreferencesPanel();
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            panel.add(Box.createVerticalStrut(6));
            panel.add(outPanel);
            panel.add(Box.createVerticalStrut(6));
            panel.add(pathsPanel);
            panel.add(Box.createVerticalStrut(6));
            panel.add(Box.createVerticalStrut(6));
            panel.add(windowsAndTabsPanel);
            panel.add(Box.createVerticalStrut(300));
            return panel;
        }
    }

    static class FirebirdOptionPage
    extends AbstractDialogPage {
        public FirebirdOptionPage(String name, Icon icon) {
            super(name, icon);
        }

        public void lazyInitialize() {
            this.initComponents();
        }

        public void initComponents() {
            BannerPanel headerPanel = new BannerPanel(this.getTitle(), null);
            headerPanel.setForeground(Color.WHITE);
            headerPanel.setBackground(new Color(10, 36, 106));
            headerPanel.setBorder(BorderFactory.createBevelBorder(1, Color.white, Color.darkGray, Color.darkGray, Color.gray));
            this.setLayout(new BorderLayout());
            this.add((Component)headerPanel, "First");
            this.add(new JLabel("This is just a demo. \"" + this.getFullTitle() + "\" page is not implemented yet.", 0), "Center");
        }
    }
}

